//
//  YHTravelDocsPreparationDetailModel.swift
//  galaxy
//
//  Created by davidhuangA on 2024/8/28.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHTravelDocsPreparationDetailModel: SmartCodable {
    var ttl: Int = -1 // 电子签证有效期
    var latest_validaty_date: String = "" // 有效期最晚时间
    var china_travel_latest_validaty_date: String = "" // 中国居留许可签证有效期最晚时间
    var age: Int = 0
    var list: [YHTravelDocsPreparationDetailItemModel?] = [] // 电子签证有效期
    
    required init() {
        
    }
}

class YHTravelDocsPreparationDetailItemModel: SmartCodable {
    var type: Int = -1// 证件类型 1-护照 2-中国旅行证 3-港澳通行证 4-存款证明 5-其他
    var order_id: Int = -1// 订单id
    var order_sn: String = ""// 合同号
    var img_back: String = ""// 逗留D上传链接(背面附件)
    var img_front: String = ""// 逗留D上传链接(正面附件)
    var status: Int = -1// 状态 0-待审核 1-通过 2-拒绝
    var issue_start: String = ""// 卡片有效期
    var issue_end: String = ""// 卡片结束有效期
    var user_id: Int = -1// 用户id
    var user_type: String = ""// 用户类型 主申请人-applicant 配偶-spouse 孩子-child 母亲-mother 父亲-father 兄弟姐妹-brother
    var remark: String  = ""// 备注
    var nationality: String = ""// 国籍 1-中国 2-国外
    
    // 自定义
    // 是否检测证件
    var isNeedCheckCer: Bool = false
    // 证件错误信息
    var checkTips: String = ""
    // 是否显示被拒理由
    var isNeedShowRejectReason: Bool = false  
    
    var latest_validaty_date: String = "" // 有效期最晚时间
    var china_travel_latest_validaty_date: String = "" // 中国居留许可签证有效期最晚时间
    var age: Int = 0

    // 是否检测时间
    var isNeedCheckDate: Bool = false
    // 是否可编辑
    var isCanEdit: Bool = true
    // OCR识别失败
    var isOCR_failed: Bool = false
    //
    var frontUrlDate: TimeInterval = 0
    var backUrlDate: TimeInterval = 0

    required init() {
        
    }
    
    init(type: Int, order_id: Int, order_sn: String, img_back: String, img_front: String, status: Int, issue_start: String, issue_end: String, user_id: Int, user_type: String, remark: String, nationality: String, age: Int) {
        
        self.type = type
        self.order_id = order_id
        self.order_sn = order_sn
        self.img_back = img_back
        self.img_front = img_front
        self.status = status
        self.issue_start = issue_start
        self.issue_end = issue_end
        self.user_id = user_id
        self.user_type = user_type
        self.remark = remark
        self.nationality = nationality
        self.age = age

    }
    
    func isValidCer() -> Bool {
        
        if self.type == 2 { // 中国居留许可签证
            if self.age < 11 { // 小于11岁的不检测
                return true
            }
            if self.china_travel_latest_validaty_date.isEmpty { // 截止日期为空
                return false
            }
            let isValid = self.compareDates(dateString1: self.issue_end, dateString2: self.china_travel_latest_validaty_date)
            return isValid
        }
        
        if self.latest_validaty_date.isEmpty { // 截止日期为空
            return true
        }
        
        let isValid = self.compareDates(dateString1: self.issue_end, dateString2: self.latest_validaty_date)
        return isValid
    }
    
    // 比较 dateString1 与 dateString2 的日期大小
    func compareDates(dateString1: String, dateString2: String) -> Bool {
        let dateFormatter = DateFormatter()
        dateFormatter.dateFormat = "yyyy-MM-dd"
        
        guard let date1 = dateFormatter.date(from: dateString1),
              let date2 = dateFormatter.date(from: dateString2) else {
            return false
        }
        
        if date1 < date2 {
            return false
        }
        return true
    }
}
